<div class="mangosm-manga-nav row gy-2  px-3 px-lg-0">
    <select aria-label="chapters list" class="mangosm-manga-nav-select col-md-8">
        <?php
        $args = array(
            'post_type' => 'comic',
            'orderby' => 'menu_order',
            'order' => 'DESC', // Order by ascending menu order
            'posts_per_page' => -1, // Get all posts
        );

        $comic_query = new WP_Query($args);

        $selected_post_id = get_the_ID(); // Get ID of currently selected post, assuming this is in a post context
        
        if ($comic_query->have_posts()):
            while ($comic_query->have_posts()):
                $comic_query->the_post();
                $option_value = esc_url(get_permalink());
                $option_text = esc_html(extract_chapter_title(get_the_title()));
                $selected = ($selected_post_id == get_the_ID()) ? 'selected' : '';
                ?>
                <option value="<?php echo $option_value; ?>" <?php echo $selected; ?>>
                    <?php echo $option_text; ?>
                </option>
                <?php
            endwhile;
            wp_reset_postdata(); // Restore global post data
        else:
            ?>
            <option value="">No comics found</option>
        <?php endif; ?>
    </select>
        
    <div
        class="col-md-4 mangosm-manga-nav-pevnext d-flex flex-row justify-content-md-end justify-content-between my-2 my-md-0">
        <?php
        // Get current post ID
        $current_post_id = get_the_ID();

        // Get previous and next post objects based on menu_order
        $prev_post = get_adjacent_post_by_menu_order($current_post_id, 'prev');
        $next_post = get_adjacent_post_by_menu_order($current_post_id, 'next');

        // Output custom navigation links if previous or next posts exist
        if ($prev_post || $next_post) {
            if ($prev_post): ?>
                <a aria-label="<?php echo esc_attr(get_the_title($prev_post)); ?>"
                    href="<?php echo get_permalink($prev_post->ID); ?>" class="prev-chapter-link">
                    <i class="icon-chevron-left"></i> &nbsp;Prev
                </a>
            <?php endif; ?>

            <?php
    if (shortcode_exists('mangosm_report_chapter_button')) {
        echo do_shortcode('[mangosm_report_chapter_button]');
    }
    ?>

            <?php if ($next_post): ?>
                <a aria-label="<?php echo esc_attr(get_the_title($next_post)); ?>"
                    href="<?php echo get_permalink($next_post->ID); ?>" class="next-chapter-link">
                    Next &nbsp;<i class="icon-chevron-right"></i>
                </a>
            <?php else: ?>
                
                <a href="<?php echo home_url(); ?>" class="next-chapter-link ">
                    Home &nbsp;<i class="icon-chevron-right"></i>
                </a>
            <?php endif;
        } else { 
            if (shortcode_exists('mangosm_report_chapter_button')) {
                echo do_shortcode('[mangosm_report_chapter_button]');
            }
            ?>
            <a href="<?php echo home_url(); ?>" class="next-chapter-link">
                Home &nbsp;<i class="icon-chevron-right"></i>
            </a>

            
        <?php } ?>

        
    </div>


</div>