<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package mangosm
 */

?>

</div><!-- #content -->

<footer class="footer-bottom pt-3 pb-3">
    <div class="container-fluid">
        <div class="site-info" align="center">
            <a href="<?php echo esc_url(home_url('/')); ?>privacy-policy/">Privacy Policy</a> | <a
                href="<?php echo esc_url(home_url('/')); ?>terms-of-use/">Terms of Use</a> | <a
                href="<?php echo esc_url(home_url('/')); ?>dmca/">DMCA</a>
        </div>
        <div align="center"> All comics on this site are the property of their respective publishers and creators. The
            translations are fan-made and intended solely as previews for audiences without access to official versions.
            If you enjoy the content, please support the creators by purchasing the official releases when available.
        </div>
        <div class="row">
            <div class="col-12 d-flex align-items-center justify-content-center">
                <div class="site-info" align="center">

                    <?php
                    $output = '<span>';
                    $output .= '&copy;';
                    $output .= date('Y') . ' ';
                    $output .= '<a href="' . esc_url(home_url('/')) . '">';
                    $output .= esc_attr(get_bloginfo('name', 'display'));
                    $output .= '</a>.';
                    $output .= esc_html__(' All rights reserved', 'mangosm');
                    $output .= '</span>';


                    echo $output;
                    ?>
                </div><!-- .site-info -->
            </div>
        </div>





</footer>
</div><!-- #page -->

<div class="sy-icon-file" style="display: none;"><?php require get_template_directory() . '/sy-svg-icons.php'; ?>
</div>



<?php wp_footer(); ?>

<a href="#" id="back-to-top" title="Back to top">
    <i class="icon-arrow-up"></i>
</a>