<?php

/*
Plugin Name: Mangosm Accessibility Plugin
Description: Adds an accessibility button for the Mangosm theme. Created by osmZ.
Version: 1.0
Author: osmZ
*/

function accessibility_button_shortcode()
{

    ob_start();
    ?>
    <div id="accessibility-container">
        <button id="accessibility-button" aria-label="open/close accessibilty menu"><i class="icon-eye"></i></button>
        <div id="accessibility-menu" class="d-none animate-slide-in">

            <div class="accessibility-menu-item ">
                <label for="accessibility-brightness">Brightness:</label>
                <input type="range" id="accessibility-brightness" name="brightness" min="0.1" max="1" step="0.1" value="1">
            </div>
            <div class="accessibility-menu-item">
                <label for="accessibility-saturation">Saturation:</label>
                <input type="range" id="accessibility-saturation" name="saturation" min="0" max="1" step="0.2" value="0">
            </div>
            <div class="accessibility-menu-item">
                <label for="accessibility-width">Width:</label>
                <input type="range" id="accessibility-width" name="width" min="300" max="700" step="100" value="700">
            </div>
        </div>
    </div>

    <?php
    return ob_get_clean();
}

add_shortcode('accessibility_button', 'accessibility_button_shortcode');

/* Enqeuque js script */

function mangosm_accessibility_enqueue_scripts()
{
    if (is_singular('comic')) {
        wp_enqueue_script(
            'mangosm-accessibilty',
            plugin_dir_url(__FILE__) . 'js/mangosm-accessibilty.js',
            [],
            false,
            true
        );
    }
}
add_action('wp_enqueue_scripts', 'mangosm_accessibility_enqueue_scripts');

function mangosm_accessibility_enqueue_styles()
{
    if (is_singular('comic')) {
        wp_enqueue_style(
            'mangosm-accessibilty-style',
            plugin_dir_url(__FILE__) . 'css/style.css'
        );
    }
}
add_action('wp_enqueue_scripts', 'mangosm_accessibility_enqueue_styles');