document.addEventListener('DOMContentLoaded', function () {

    let brightnessValue = 1;
    let saturationValue = 0;

    const screenWidth = window.innerWidth;
    let width = screenWidth < 700 ? screenWidth : 700;

    const widthInput = document.getElementById('accessibility-width');
    const brightnessInput = document.getElementById('accessibility-brightness');
    const saturationInput = document.getElementById('accessibility-saturation');
    const images = document.querySelectorAll('.images-container img');
    const accessibilityButton = document.getElementById('accessibility-button');
    const accessibilityMenu = document.getElementById('accessibility-menu');
    const accessibilityIcon = accessibilityButton.querySelector('i');

    // Set width input min/max/step
    widthInput.min = 300;
    widthInput.max = width;
    widthInput.step = screenWidth > 700 ? (width - 300) / 4 : (width - 300) / 2;
    widthInput.value = width;

    // Load values from localStorage if available
    if (localStorage.getItem('accessibility-saturation') !== null) {
        saturationValue = localStorage.getItem('accessibility-saturation');
        saturationInput.value = saturationValue;
    }

    if (localStorage.getItem('accessibility-brightness') !== null) {
        brightnessValue = localStorage.getItem('accessibility-brightness');
        brightnessInput.value = brightnessValue;
    }

    if (localStorage.getItem('accessibility-width') !== null) {
        width = localStorage.getItem('accessibility-width');
        widthInput.value = width;
        images.forEach(img => img.style.maxWidth = width + 'px');
    }

    // Apply initial filters
    images.forEach(img => {
        img.style.filter = `sepia(${saturationValue}) brightness(${brightnessValue})`;
    });

    // Toggle accessibility menu and icon
    accessibilityButton.addEventListener('click', () => {
        accessibilityIcon.classList.add('rotate');

        accessibilityMenu.classList.toggle('d-none');
        accessibilityIcon.classList.toggle('icon-eye');
        accessibilityIcon.classList.toggle('icon-close');

        setTimeout(() => {
            accessibilityIcon.classList.remove('rotate');
        }, 500);
    });

    // Brightness input event
    brightnessInput.addEventListener('input', function () {
        brightnessValue = this.value;
        localStorage.setItem('accessibility-brightness', brightnessValue);
        applyFilters();
    });

    // Saturation input event
    saturationInput.addEventListener('input', function () {
        saturationValue = this.value;
        localStorage.setItem('accessibility-saturation', saturationValue);
        applyFilters();
    });

    // Width input event
    widthInput.addEventListener('input', function () {
        width = this.value;
        localStorage.setItem('accessibility-width', width);
        widthInput.value = width;
        images.forEach(img => img.style.maxWidth = width + 'px');
    });

    // Function to apply filters
    function applyFilters() {
        images.forEach(img => {
            img.style.filter = `sepia(${saturationValue}) brightness(${brightnessValue})`;
        });
    }

});
