<?php
/*
Plugin Name: Manga Read More Generator For Mangosm Theme
Description: Generates a "read more" section with a grid of manga cards under a chapter.
Version: 1.0
Author: osmZ
*/

// Add the admin menu item
add_action('admin_menu', 'manga_read_more_add_admin_menu');
function manga_read_more_add_admin_menu()
{
    add_menu_page(
        'Manga Read More',
        'Manga Read More',
        'manage_options',
        'manga-read-more',
        'manga_read_more_settings_page'
    );
}

function manga_read_more_settings_page()
{
    $mangas = get_option('manga_read_more_mangas', []);

    // Handle Manga Add
    if (!empty($_POST['manga_name']) && !empty($_POST['manga_image']) && !empty($_POST['manga_link'])) {
        manga_read_more_add_manga($_POST['manga_name'], $_POST['manga_image'], $_POST['manga_link']);
    }

    ?>
    <div class="wrap">
        <h1>Manga Read More Section</h1>
        <form method="post" action="">
            <label for="manga_name">Manga Name</label>
            <input type="text" name="manga_name" id="manga_name" value="" />
            <label for="manga_image">Image URL</label>
            <input type="url" name="manga_image" id="manga_image" value="" />
            <label for="manga_link">Manga Link</label>
            <input type="url" name="manga_link" id="manga_link" value="" />
            <input type="submit" value="Add Manga" />
        </form>

        <?php if (!empty($mangas)): ?>
            <h3>Existing Mangas</h3>
            <table class="widefat fixed">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Name'); ?></th>
                        <th><?php esc_html_e('Image'); ?></th>
                        <th><?php esc_html_e('Link'); ?></th>
                        <th><?php esc_html_e('Actions'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($mangas as $index => $manga): ?>
                        <tr>
                            <td><?php echo esc_html($manga['name']); ?></td>
                            <td><img src="<?php echo esc_url($manga['image_url']); ?>" width="150" height="auto" /></td>
                            <td><a href="<?php echo esc_url($manga['link']); ?>" target="_blank">View Manga</a></td>
                            <td>
                                <a style="cursor:pointer;" class="delete-manga"
                                    data-index="<?php echo esc_attr($index); ?>">Delete</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
    <?php
}

// Store Manga Info (name, image, link)
function manga_read_more_add_manga($name, $image_url, $link)
{
    $mangas = get_option('manga_read_more_mangas', []);
    $mangas[] = [
        'name' => sanitize_text_field(trim($name)),
        'image_url' => esc_url($image_url),
        'link' => esc_url($link),
    ];
    update_option('manga_read_more_mangas', $mangas);
}

// Delete Manga Info by index
function manga_read_more_delete_manga($index)
{
    $mangas = get_option('manga_read_more_mangas', []);
    if (isset($mangas[$index])) {
        unset($mangas[$index]);
        $mangas = array_values($mangas); // Reindex the array
        update_option('manga_read_more_mangas', $mangas);
    }
}



// Handle AJAX Request for Deleting Manga
function manga_read_more_delete_ajax()
{
    if (isset($_POST['index'])) {
        $index = intval($_POST['index']);
        manga_read_more_delete_manga($index);
        wp_send_json_success();
    }
    wp_send_json_error();
}
add_action('wp_ajax_manga_read_more_delete', 'manga_read_more_delete_ajax');

function manga_read_more_enqueue_scripts($hook)
{
    // Check if we're on the plugin's settings page
    if ($hook !== 'toplevel_page_manga-read-more') {
        return;
    }

    wp_enqueue_script('jquery'); // Make sure jQuery is loaded
    wp_enqueue_script('manga-read-more', plugin_dir_url(__FILE__) . 'js/manga-read-more.js', array('jquery'), null, true);
    wp_localize_script('manga-read-more', 'mangaReadMore', array(
        'ajax_url' => admin_url('admin-ajax.php'), // For AJAX requests
    ));
}
add_action('admin_enqueue_scripts', 'manga_read_more_enqueue_scripts');



// Shortcode to display Manga "Read More" section
function manga_read_more_shortcode()
{
    $mangas = get_option('manga_read_more_mangas', []);
    ob_start(); // Start output buffering
    ?>
    <?php if (!empty($mangas)): ?>
        <p class="read-more-title">More From Us</p>
        <div class="manga-read-more-section">
            <?php foreach ($mangas as $index => $manga): ?>
                <div class="manga-card">
                    <a href="<?php echo esc_url($manga['link']); ?>" target="_blank">
                        <div class="image-container">
                            <img loading="lazy" src="<?php echo esc_url($manga['image_url']); ?>"
                                alt="<?php echo esc_attr($manga['name']); ?> manga cover" />
                        </div>
                        <p class="text-center"><?php echo esc_html($manga['name']); ?></p>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
    <?php
    return ob_get_clean(); // Return the output buffer
}

add_shortcode('manga_read_more', 'manga_read_more_shortcode');




/* Code to load css file for cards styling */
function manga_read_more_enqueue_styles()
{

    if (is_singular('comic')) {
        wp_enqueue_style('manga-read-more-style', plugin_dir_url(__FILE__) . 'css/style.css');
    }
    
}
add_action('wp_enqueue_scripts', 'manga_read_more_enqueue_styles');
